#include "pdb.h"

#include <math.h>
#include <fstream>

#include "Varia.h"

/*******************************************************/
/***********************   ATOM   **********************/
/*******************************************************/

/* static */ bool Atom::CzyRekordZDanymi(const char* pdbRecord)
{
    //fraza ATOM powinna byc na poczatku lancucha
    return strstr(pdbRecord,"ATOM")==pdbRecord;
}

/* static */ char* Atom::WyodrebnijSymbolPierwiastka(const char* name,char* elementSymbol)
{
    strcpy(elementSymbol,"\0\0\0");
    int index=0;
    do
    {
        //atomSymbol[0]=toupper(name[index]);
        elementSymbol[0]=name[index];
        index++;
    }
    while(elementSymbol[0]<'A' || elementSymbol[0]>'Z'); //pierwsza litera - wielka litera
    if(name[index]>='a' && name[index]<='z')
    {
        elementSymbol[1]=name[index];
    }
    else elementSymbol[1]='\0';
    elementSymbol[2]='\0';
    return elementSymbol;
}

Atom::Atom(const char* pdbRecord)
{
    this->pdbRecord=new char[strlen(pdbRecord)+1];
    strcpy(this->pdbRecord,pdbRecord);
    ParsujRekord(this->pdbRecord);
}

Atom::~Atom()
{
    delete [] pdbRecord;
}

void Atom::ParsujRekord(const char* pdbRecord)
{
    char s_serial[5], s_resSeq[4],
         s_X[8], s_Y[8], s_Z[8],
         s_occupancy[6],s_tempFactor[6],s_charge[3],
         *endptr;

    strncpy(recordName,pdbRecord,6); //0-5
    recordName[6]='\0';
    strncpy(s_serial,pdbRecord+6,5); //6-10, 11=spacja
    serial=strtol(s_serial,&endptr,10);
    strncpy(name,pdbRecord+12,4); //12-15
    name[4]='\0';
    altLoc=pdbRecord[16]; //16
    strncpy(resName,pdbRecord+17,3); //17-19, 20=spacja
    resName[3]='\0';
    chainID=pdbRecord[21]; //21
    strncpy(s_resSeq,pdbRecord+22,4); //22-25
    resSeq=strtol(s_resSeq,&endptr,10);
    iCode=pdbRecord[26]; //26
    strncpy(s_X,pdbRecord+30,8); //30-37
    X=strtod(s_X,&endptr);
    strncpy(s_Y,pdbRecord+38,8); //38-45
    Y=strtod(s_Y,&endptr);
    strncpy(s_Z,pdbRecord+46,8); //46-53
    Z=strtod(s_Z,&endptr);
    strncpy(s_occupancy,pdbRecord+54,6); //54-59
    occupancy=strtod(s_occupancy,&endptr);
    strncpy(s_tempFactor,pdbRecord+60,6); //60-65, 66-75=spacje
    tempFactor=strtod(s_tempFactor,&endptr);
    strncpy(element,pdbRecord+76,2); //76-77
    element[2]='\0';
    strncpy(s_charge,pdbRecord+78,2); //78-79
    charge=strtod(s_charge,&endptr);

    //usuwanie spacji
    trim(recordName);
    trim(name);
    trim(resName);
    trim(element);
}

Wektor Atom::Polozenie() const
{
    return Wektor(X,Y,Z);
}


/*******************************************************/
/************************   PDB   **********************/
/*******************************************************/

PDB::PDB(const char *nazwaPliku)
    :nazwaPliku(nazwaPliku),iloscWierszyDanych(0)
{
	AnalizaPliku(); //moze zglosic wyjatek
    atomy=new Atom* [iloscWierszyDanych];
    for(int i=0;i<iloscWierszyDanych;i++) atomy[i]=NULL; //potrzebne do usuwania

	CzytajDaneZPliku(); //moze zglosic wyjatek
}

PDB::~PDB()
{
    for(int indeks=0;indeks<iloscWierszyDanych;indeks++) delete atomy[indeks];
    delete [] atomy;
}

/*static*/ bool PDB::CzyMarkerKoncaKlatki(const char* pdbRecord)
{
    return strstr(pdbRecord,"END")==pdbRecord;
}

void PDB::AnalizaPliku() //z analizy wyciagam informacje o wielkosci tablicy atomow, ktora nalezy zaalokowac
{
    if(!filetest(nazwaPliku)) throw std::logic_error("Wskazany plik PDB nie istnieje");	

    const int maksRozmiarLinii=256; //zgodnie z dokumentacja PDB wystarczyloby 80
    char linia[maksRozmiarLinii]="\0";

    iloscWierszyDanych=0;

    std::ifstream plik_we(nazwaPliku,std::ios_base::in);

    //dane
    while(!CzyMarkerKoncaKlatki(linia)) //do konca pierwszej ramki, plik PDB moze miec ich wiele
    {
        plik_we.getline(linia,maksRozmiarLinii);
		if(Atom::CzyRekordZDanymi(linia)) iloscWierszyDanych++;
    }

    plik_we.close();
}


void PDB::CzytajDaneZPliku() //jedna klatka
{
	const int maksRozmiarLinii=256; //zgodnie z dokumentacja PDB wystarczyloby 80
	char linia[maksRozmiarLinii]="\0";

    //otwieranie pliku na czas istnienia obiektu
	std::ifstream plik_we(nazwaPliku,std::ios_base::in);

    //dane
    for(int indeks=0;indeks<iloscWierszyDanych;indeks++)
    {
        plik_we.getline(linia,maksRozmiarLinii);
		if(!Atom::CzyRekordZDanymi(linia)) indeks--;
        else
        {
            if (atomy[indeks]!=NULL) delete atomy[indeks]; //kasowanie poprzedniego obiektu
            atomy[indeks]=new Atom(linia);
			/*
            if(atomy[indeks]->serial-1!=indeks)
            {                
                throw std::logic_error("Numer atomu w pliku PDB nie zgadza sie z indeksem");                
				plik_we.close();
            }
			*/
            if (CzyMarkerKoncaKlatki(linia))
            {
				throw std::logic_error("Przedwczesny koniec klatki");
				plik_we.close();
            }
        }
    }

	plik_we.close();
}

int PDB::LiczbaAtomow() const
{
    return iloscWierszyDanych;
}

Atom* PDB::PobierzAtom(int indeks) const
{
	if(indeks<0 || indeks>=iloscWierszyDanych) return NULL;
    return atomy[indeks];
}

Wektor PDB::SrodekMasy() const
{
    Wektor srodekMasy(0.0,0.0,0.0);
    for(int indeks=0;indeks<iloscWierszyDanych;indeks++)
    {
        srodekMasy+=atomy[indeks]->Polozenie();
    }
    srodekMasy/=(double)iloscWierszyDanych;
    return srodekMasy;
}
